/*
 * TagTreeProxy.cpp
 *
 *  Created on: 22.10.2009
 *      Author: stefan.detter
 */

#include "TagTreeProxy.h"

#include "../data/ReaderEntry.h"
#include "../data/TagEntry.h"


TagTreeProxy::TagTreeProxy(QObject* parent)
	: QSortFilterProxyModel(parent)
{
}

TagTreeProxy::~TagTreeProxy()
{
}

void TagTreeProxy::expandSlot ( const QModelIndex & index )
{
	emit expand( mapFromSource(index) );
}

void TagTreeProxy::setCurrentIndexSlot ( const QModelIndex & index )
{
	emit setCurrentIndex( mapFromSource(index) );
}

void TagTreeProxy::setRootIndexSlot ( const QModelIndex & index )
{
	emit setRootIndex( mapFromSource(index) );
}



void TagTreeProxy::clickedSlot ( const QModelIndex & index )
{
	emit clicked( mapToSource(index) );
}

void TagTreeProxy::doubleClickedSlot ( const QModelIndex & index )
{
	emit doubleClicked( mapToSource(index) );
}

bool TagTreeProxy::lessThan(const QModelIndex &left, const QModelIndex &right) const
{
	TreeItem* leftItem = static_cast<TreeItem*>( left.internalPointer() );
	TreeItem* rightItem = static_cast<TreeItem*>( right.internalPointer() );

	if(leftItem->itemType() == TreeItem::READER && rightItem->itemType() == TreeItem::READER)
		return ((ReaderEntry*)leftItem)->readerId() < ((ReaderEntry*)rightItem)->readerId();

//	if(leftItem->itemType() == TreeItem::TAG && rightItem->itemType() == TreeItem::TAG)
//		return ((TagEntry*)leftItem)->tagId() < ((TagEntry*)rightItem)->tagId();

	QVariant leftData = sourceModel()->data(left);
	QVariant rightData = sourceModel()->data(right);

	return leftData.toString() < rightData.toString();
}
